/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BooleanCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::BooleanCommandLineQuery::BooleanCommandLineQuery(Parameter<bool> &_param, std::string title, std::string _description) :
    Dialog::TQuery<bool>(_param, title, _description)
{}

CommandLineDialog::BooleanCommandLineQuery::~BooleanCommandLineQuery() {}

bool CommandLineDialog::BooleanCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as<bool>();
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing boolean for " << getTitle() << ".");
    return false;
  }
}

