#ifndef NANOCREATOR_H_
#define NANOCREATOR_H_

#define MYEPSILON 1e-13

struct Atoms
{
    char name[3];
    double x[3];
};

// file stuff
char * ReadBuffer (char *filename, int *bufferlength); 
void AddAtomicNumber(char *filename, int atomicnumber, double **Vector, double **Recivector);
void AddSheetInfo(char *filename, int *axis, int *chiral, int *factors, int seed, int numbercell, double *randomness);
int GetNextline(char *buffer, char *line);

// matrix stuff
void MatrixInversion(double **matrix1ref, double **matrix2ref);
void MatrixInversion(double **matrix1ref, double **matrix2ref);
double Determinant(double **matrix);
void PrintMatrix(FILE *file, double **matrix);

// vector stuff
double * MatrixTrafo(double **matrixref, double *vectorref);
double * VectorAdd(double *vector1, double *vector2);
void Orthogonalize(double **orthvector, int *axis);
double Projection(double *vector1, double *vector2);
double ScalarProduct(double *vector1, double *vector2);
double Norm(double *vector); 
void PrintVector(FILE *file, double *vector);

double DetermineBiggestDiameter(double **matrix, int *axis, int *factors);
double * CenterOfGravity(char *bufptr, int number);
void Debug(char *msg);

#endif /*NANOCREATOR_H_*/
