/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Ops_FillPredicate.cpp
 *
 *  Created on: 17.01.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Ops_FillPredicate.hpp"
#include "Ops_FillPredicate_impl.hpp"

FillPredicate operator&&(const FillPredicate &a, const FillPredicate &b)
{
  FillPredicate::impl_ptr impl_ptr = FillPredicate::impl_ptr(
      new And_FillPredicate(getFillPredicateImpl(a),getFillPredicateImpl(b)));
	return FillPredicate(impl_ptr);
}

FillPredicate operator||(const FillPredicate &a, const FillPredicate &b)
{
  FillPredicate::impl_ptr impl_ptr = FillPredicate::impl_ptr(
      new Or_FillPredicate(getFillPredicateImpl(a),getFillPredicateImpl(b)));
  return FillPredicate(impl_ptr);
}

FillPredicate operator!(const FillPredicate &a)
{
  FillPredicate::impl_ptr impl_ptr = FillPredicate::impl_ptr(
      new Not_FillPredicate(getFillPredicateImpl(a)));
  return FillPredicate(impl_ptr);
}
