/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Dialog.hpp"
#include "Actions/ValueStorage.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

class Atom;
class Box;
class element;
class RealSpaceMatrix;
class molecule;
class Vector;

using namespace std;

Dialog::Dialog()
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  if(checkAll()){
    setAll();
    return true;
  }
  else{
    return false;
  }
}

bool Dialog::checkAll(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->handle();
    // if any query fails (is canceled), we can end the handling process
    if(!retval) {
      DoeLog(1) && (eLog() << Verbose(1) << "The following query failed: " << (**iter).getTitle() << "." << endl);
      break;
    }
  }
  return retval;
}

void Dialog::setAll(){
  list<Query*>::iterator iter;
  for(iter=queries.begin(); iter!=queries.end(); iter++) {
    (*iter)->setResult();
  }
}

bool Dialog::hasQueries(){
  return queries.size();
}

template <> void Dialog::query<void *>(const char *token, std::string description)
{
  queryEmpty(token, description);
}

template <> void Dialog::query<bool>(const char *token, std::string description)
{
  queryBoolean(token, description);
}

template <> void Dialog::query<int>(const char *token, std::string description)
{
  queryInt(token, description);
}

template <> void Dialog::query< std::vector<int> >(const char *token, std::string description)
{
  queryInts(token, description);
}

template <> void Dialog::query<unsigned int>(const char *token, std::string description)
{
  queryUnsignedInt(token, description);
}

template <> void Dialog::query<double>(const char *token, std::string description)
{
  queryDouble(token, description);
}

template <> void Dialog::query< std::vector<double> >(const char *token, std::string description)
{
  queryDoubles(token, description);
}

template <> void Dialog::query<std::string>(const char *token, std::string description)
{
  queryString(token, description);
}

template <> void Dialog::query< std::vector<std::string> >(const char *token, std::string description)
{
  queryStrings(token, description);
}

template <> void Dialog::query<const atom *>(const char *token, std::string description)
{
  queryAtom(token, description);
}

template <> void Dialog::query< std::vector<const atom *> >(const char *token, std::string description)
{
  queryAtoms(token, description);
}

template <> void Dialog::query<const molecule *>(const char *token, std::string description)
{
  queryMolecule(token, description);
}

template <> void Dialog::query< std::vector<const molecule *> >(const char *token, std::string description)
{
  queryMolecules(token, description);
}

template <> void Dialog::query<Vector>(const char *token, std::string description)
{
  queryVector(token, false, description);
}

template <> void Dialog::query< std::vector<Vector> >(const char *token, std::string description)
{
  queryVectors(token, false, description);
}

template <> void Dialog::query<BoxVector>(const char *token, std::string description)
{
  queryVector(token, true, description);
}

template <> void Dialog::query< std::vector<BoxVector> >(const char *token, std::string description)
{
  queryVectors(token, true, description);
}

template <> void Dialog::query<Box>(const char *token, std::string description)
{
  queryBox(token, description);
}

template <> void Dialog::query<const element *>(const char *token, std::string description)
{
  queryElement(token, description);
}

template <> void Dialog::query< std::vector<const element *> >(const char *token, std::string description)
{
  queryElements(token, description);
}

template <> void Dialog::query< boost::filesystem::path >(const char *token, std::string description)
{
  queryFile(token, description);
}

template <> void Dialog::query< RandomNumberDistribution_Parameters >(const char *token, std::string description)
{
  queryRandomNumberDistribution_Parameters(token, description);
}

/************************** Query Infrastructure ************************/
/*       ---> shifted to folder Query                                   */
/************************************************************************/
