/*
 * CommandLineDialog.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEDIALOG_HPP_
#define COMMANDLINEDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>

class atom;
class element;
class molecule;
class Vector;

#include "Dialog.hpp"

/** CommandLineUIFactory implementation of the Dialog.
 * The idea here is that for each query the parsed command line options are used instead.
 */
class CommandLineDialog : public Dialog
{
public:
  CommandLineDialog();
  virtual ~CommandLineDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryInt(const char *, std::string = "");
  virtual void queryInts(const char *, std::string = "");
  virtual void queryUnsignedInt(const char *, std::string = "");
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryString(const char*, std::string = "");
  virtual void queryStrings(const char*, std::string = "");
  virtual void queryDouble(const char*, std::string = "");
  virtual void queryDoubles(const char*, std::string = "");
  virtual void queryAtom(const char*, std::string = "");
  virtual void queryAtoms(const char*, std::string = "");
  virtual void queryMolecule(const char*, std::string = "");
  virtual void queryMolecules(const char*, std::string = "");
  virtual void queryVector(const char*, bool, std::string = "");
  virtual void queryVectors(const char*, bool, std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*, std::string = "");
  virtual void queryElements(const char*, std::string = "");
  virtual void queryFile(const char*, std::string = "");
  virtual void queryRandomNumberDistribution_Parameters(const char*, std::string = "");
protected:
  // specialized stuff for command line queries
  // all placed into Query/CommandLineQuery.hpp
  // !please adhere to alphabetical ordering!
  class AtomCommandLineQuery;
  class AtomsCommandLineQuery;
  class BooleanCommandLineQuery;
  class BoxCommandLineQuery;
  class DoubleCommandLineQuery;
  class DoublesCommandLineQuery;
  class ElementCommandLineQuery;
  class ElementsCommandLineQuery;
  class EmptyCommandLineQuery;
  class FileCommandLineQuery;
  class IntCommandLineQuery;
  class IntsCommandLineQuery;
  class MoleculeCommandLineQuery;
  class MoleculesCommandLineQuery;
  class StringCommandLineQuery;
  class StringsCommandLineQuery;
  class UnsignedIntCommandLineQuery;
  class VectorCommandLineQuery;
  class VectorsCommandLineQuery;
  class RandomNumberDistribution_ParametersCommandLineQuery;
};

#endif /* COMMANDLINEDIALOG_HPP_ */
