/*
 * QtDialog.hpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

#ifndef QTDIALOG_HPP_
#define QTDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QObject>

#include "Parameters/Parameter.hpp"
#include "UIElements/Dialog.hpp"
#include <QtGui/QDialog>

#include <map>
#include <set>
#include <vector>

class QBoxLayout;
class QDialogButtonBox;

class QtDialog : public QDialog, public Dialog
{
  Q_OBJECT
public:
  QtDialog(const std::string &_title);
  virtual ~QtDialog();

  virtual void queryEmpty(const std::string ="", const std::string = "");
  virtual void queryBoolean(Parameter<bool> &, const std::string ="", const std::string = "");
  virtual void queryInt(Parameter<int> &, const std::string ="", const std::string = "");
  virtual void queryInts(Parameter<std::vector<int> > &, const std::string ="", const std::string = "");
  virtual void queryUnsignedInt(Parameter<unsigned int> &, const std::string ="", const std::string = "");
  virtual void queryUnsignedInts(Parameter<std::vector<unsigned int> > &, const std::string ="", const std::string = "");
  virtual void queryDouble(Parameter<double> &, const std::string ="", const std::string = "");
  virtual void queryDoubles(Parameter<std::vector<double> > &, const std::string ="", const std::string = "");
  virtual void queryString(Parameter<std::string> &, const std::string ="", const std::string = "");
  virtual void queryStrings(Parameter<std::vector<std::string> > &, const std::string ="", const std::string = "");
  virtual void queryAtom(Parameter<const atom *> &, const std::string ="", const std::string = "");
  virtual void queryAtoms(Parameter<std::vector<const atom *> > &, const std::string ="", const std::string = "");
  virtual void queryMolecule(Parameter<const molecule *> &, const std::string ="", const std::string = "");
  virtual void queryMolecules(Parameter<std::vector<const molecule *> > &, const std::string ="", const std::string = "");
  virtual void queryVector(Parameter<Vector> &, const std::string ="", const std::string = "");
  virtual void queryVectors(Parameter<std::vector<Vector> > &, const std::string ="", const std::string = "");
  virtual void queryRealSpaceMatrix(Parameter<RealSpaceMatrix> &, const std::string ="", const std::string = "");
  virtual void queryElement(Parameter<const element *> &, const std::string ="", const std::string = "");
  virtual void queryElements(Parameter<std::vector<const element *> > &, const std::string ="", const std::string = "");
  virtual void queryFile(Parameter<boost::filesystem::path> &, const std::string ="", const std::string = "");
  virtual void queryFiles(Parameter<std::vector< boost::filesystem::path> > &, const std::string ="", const std::string = "");
  virtual void queryRandomNumberDistribution_Parameters(Parameter<RandomNumberDistribution_Parameters> &, const std::string ="", const std::string = "");

  virtual bool display();

  virtual void update();

protected:
  class AtomQtQuery;
  class AtomsQtQuery;
  class BooleanQtQuery;
  class RealSpaceMatrixQtQuery;
  class DoubleQtQuery;
  class DoublesQtQuery;
  class ElementQtQuery;
  class ElementsQtQuery;
  class EmptyQtQuery;
  class FileQtQuery;
  class FilesQtQuery;
  class IntQtQuery;
  class IntsQtQuery;
  class MoleculeQtQuery;
  class MoleculesQtQuery;
  class StringQtQuery;
  class StringsQtQuery;
  class UnsignedIntQtQuery;
  class UnsignedIntsQtQuery;
  class VectorQtQuery;
  class VectorsQtQuery;
  class RandomNumberDistribution_ParametersQtQuery;

private:
  QBoxLayout *mainLayout;
  QBoxLayout *inputLayout;
  QBoxLayout *buttonLayout;
  QDialogButtonBox *buttons;
};


#endif /* QTDIALOG_HPP_ */
