/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Value_elementss.cpp
 *
 *  Created on: Jul 18, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Value_elements.hpp"

#include <string>
#include <sstream>

#include <boost/lexical_cast.hpp>
#include <boost/tokenizer.hpp>

#include "CodePatterns/toString.hpp"

#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

static std::vector<const element *> FindElementsByString(const std::string &_value)
{
  typedef boost::tokenizer<boost::char_separator<char> > tokenizer;
  boost::char_separator<char> sep(" ");
  tokenizer tok(_value, sep);
  std::vector<const element *> elements;
  for(tokenizer::iterator beg=tok.begin();
      beg != tok.end();++beg) {
    const int tempvalue = boost::lexical_cast<atomicNumber_t>(*beg);
    const element * _element =
        World::getInstance().getPeriode()->FindElement(tempvalue);
    ASSERT( _element != NULL,
        "FindElementsByString() - cannnot find element "
        +toString(tempvalue)+" in periodentafel.");
    elements.push_back(_element);
  }
  return elements;
}

template <>
bool Value<std::vector<const element *> >::isValidAsString(const std::string &_value) const throw(ParameterValidatorException)
{
  try {
    FindElementsByString(_value);
  } catch (exception &e) {
    return false;
  }
  return true;
}

template <>
const std::string Value<std::vector<const element *> >::getAsString() const throw(ParameterValueException)
{
  std::stringstream output;
  for (std::vector<const element *>::const_iterator iter = get().begin();
      iter != get().end(); ++iter)
    output << (*iter)->getName();
  return output.str();
}

template <>
void Value<std::vector<const element *> >::setAsString(const std::string &_value) throw(ParameterException)
{
  std::vector<const element *> temp = FindElementsByString(_value);
  if (!temp.empty())
    set(temp);
}


