/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CreateMicelleAction.cpp
 *
 *  Created on: Sept 29, 2010
 *      Author: dueck
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Actions/ActionHistory.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/GraphAction/SubgraphDissectionAction.hpp"
#include "Actions/MoleculeAction/RotateToPrincipalAxisSystemAction.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "LinearAlgebra/Line.hpp"
#include "Parser/PdbParser.hpp"
#include "Parser/TremoloParser.hpp"
#include "Parser/XyzParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/ShapeOps.hpp"


#include "atom.hpp"
#include "Bond/bond.hpp"
#include "boundary.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/MoleculeAction/CreateMicelleAction.hpp"

#include "CreateMicelleAction.def"
#include "Action_impl_pre.hpp"

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

// memento to remember the state when undoing

#include <iostream>
#include <fstream>
#include <config.h>
#include "atom.hpp"
#include "molecule.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"
#include <gsl/gsl_poly.h>
#include <gsl/gsl_eigen.h>
#define PATH "/home/heber/tmp/"
#define AtomVector std::vector <atom *>
#define MoleculeVector std::vector <molecule *>
#define AtomList list <atom *>

int Delta2(int x1, int x2);
double Sqlength (Vector x);

/** =========== define the function ====================== */
Action::state_ptr MoleculeCreateMicelleAction::performCall() {
	
getParametersfromValueStorage();
	
AtomVector ever = World::getInstance().getAllAtoms();

// as all parsed atoms go into same molecule
// we don't need to create one and add them all to it
MoleculeVector all = World::getInstance().getSelectedMolecules();
molecule *stick = *(all.begin()); 

//3.Molekuel zentrieren

stick->CenterOrigin();

//4.Haupttraegheitsachse bestimmen
Vector den(0.0,0.0,1.0);

MoleculeRotateToPrincipalAxisSystem(den);
/* determine
principal axis system and make greatest eigenvector be aligned along
(0,0,1)
*/
string path;
/**/
{
  std::ofstream file;
  path = PATH;
  path += "/tensidrot.xyz";
  file.open(path.c_str());
  FormatParserStorage::getInstance().getXyz().save(&file, World::getInstance().getAllAtoms());
  file.close();
}

//5.b: Molekuel um 180 Grad drehen

Line RotationAxis(Vector(0.0,0.0,0.0), Vector(1.0,0.0,0.0)); // pt is the current Vector of point on surface

for (molecule::iterator it=stick->begin(); it !=stick->end(); ++it)
  (*it)->setPosition(RotationAxis.rotateVector((*it)->getPosition(),M_PI));


{
  std::ofstream file;
  path = PATH;
  path += "/tensid2rot.xyz";
  file.open(path.c_str());
  FormatParserStorage::getInstance().getXyz().save(&file, World::getInstance().getAllAtoms());
  file.close();
}

//6.Molekuel mehrfach strukturiert mit der Haupttraegheitsachse senkrecht zu einer parametrisierten Oberflaeche anordnen

//6.1. Punkte auf der Oberflaeche bestimmen
//Algorithmus entnommen aus "http://www.cgafaq.info/wiki/Evenly_distributed_points_on_sphere"

int ka =0;
double radius= 1.5*sqrt(pow(1.55, 2)*params.N);

Shape s = resize(Sphere(), radius);
std::vector<Vector> pt = s.getHomogeneousPointsOnSurface(params.N);

//6.2."stick" um Radius und Molekuelausdehnung in z-Richtung verschieben.

for (molecule::iterator it2=stick->begin();it2 !=stick->end();++it2) {
	Vector pos= (**it2).getPosition();
	pos[2]=pos[2]+radius; // -Min[2]
	(**it2).setPosition(pos);
}

{
  std::ofstream file;
  path = PATH;
  path += "/tensid3rot.xyz";
  file.open(path.c_str());
  FormatParserStorage::getInstance().getXyz().save(&file, World::getInstance().getAllAtoms());
  file.close();
}

//6.3.Erzeugen einer Molekuelliste, die das Molekuel "stick" "N" mal kopiert und um eine Sphaere herum verteilt 

//double MYEPSILON=1e-10;

for (ka = 0; ka<params.N-1; ka++){
  cout << "Creating " << ka+1 << " copy of tenside molecule 'stick' with " << stick->getAtomCount() << " atoms, ";
	molecule *Tensid=stick->CopyMolecule();

	cout << "rotating ...";
  Vector ZAxis(Vector(0.0,0.0,1.0));
  Vector Axis(pt[ka]);
  const double alpha = ZAxis.Angle(Axis);
  Axis.VectorProduct(ZAxis);
  Line RotationAxis(Vector(0.0,0.0,1.0), Axis);	// pt is the current Vector of point on surface

  for (molecule::iterator it2=Tensid->begin();it2 !=Tensid->end();++it2)
    (*it2)->setPosition(RotationAxis.rotateVector((*it2)->getPosition(),alpha));
  cout << "done." << endl;

  Tensid=NULL;
}
cout << "shifting " << ka+1 << " copy of tenside molecule, ";
	molecule *Tensid=stick;

	cout << "rotating ...";
  Vector ZAxis(Vector(0.0,0.0,1.0));
  Vector Axis(pt[params.N-1]);
  const double alpha = ZAxis.Angle(Axis);
  Axis.VectorProduct(ZAxis);
  Line RotationAxis2(Vector(0.0,0.0,1.0), Axis);	// pt is the current Vector of point on surface

  for (molecule::iterator it2=Tensid->begin();it2 !=Tensid->end();++it2)
    (*it2)->setPosition(RotationAxis.rotateVector((*it2)->getPosition(),alpha));
  cout << "done." << endl;

  Tensid=NULL;

  GraphSubgraphDissection();

  return Action::success;
}

Action::state_ptr MoleculeCreateMicelleAction::performUndo(Action::state_ptr _state) {
//  MoleculeFillVoidWithMoleculeState *state = assert_cast<MoleculeFillVoidWithMoleculeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeCreateMicelleAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}


bool MoleculeCreateMicelleAction::canUndo() {
  return false;
}


bool MoleculeCreateMicelleAction::shouldUndo() {
  return false;
}

/** =========== end of function ====================== */
