/*
 *    vmg - a versatile multigrid solver
 *    Copyright (C) 2012 Institute for Numerical Simulation, University of Bonn
 *
 *  vmg is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vmg is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file   particle.cpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Sat Sep 17 14:45:56 2011
 *
 * @brief  Class to represent a particle
 *
 */

#ifdef HAVE_CONFIG_H
#include "libvmg_config.h"
#endif

#include "units/particle/particle.hpp"

std::ostream& VMG::Particle::operator<<(std::ostream& out, const VMG::Particle::Particle& particle)
{
  return out << particle;
}
