/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DoublesQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>
#include <Qt/qlistwidget.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Query/QtQueryList.hpp"
#include "UIElements/Qt4/Pipe/QtQueryListPipe.hpp"


QtDialog::DoublesQtQuery::DoublesQtQuery(Parameter<std::vector<double> > &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::DoublesQuery(_param, _title),
    QtQueryList<double>(_parent, _dialog, temp)
{
  ListQuerySubDialog *subDialog = new ListQuerySubDialog(this);
  subQuery = new DoubleQtQuery(*subParam, _title, thisVLayout, subDialog);
  subDialog->setSubQuery(subQuery);

  connect(inputList,SIGNAL(itemSelectionChanged()),this,SLOT(onElementSelected()));
  connect(addButton,SIGNAL(clicked()),this,SLOT(onAddElement()));
  connect(removeButton,SIGNAL(clicked()),this,SLOT(onRemoveElement()));
}

QtDialog::DoublesQtQuery::~DoublesQtQuery()
{
  delete(subQuery);
}

void QtDialog::DoublesQtQuery::onSubUpdate()
{
  addButton->setEnabled(subParam->isSet());
}

void QtDialog::DoublesQtQuery::onElementSelected() {
  elementSelected();
}

void QtDialog::DoublesQtQuery::onAddElement() {
  addElement();
}

void QtDialog::DoublesQtQuery::onRemoveElement() {
  removeElements();
}

bool QtDialog::DoublesQtQuery::handle()
{
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}



