/*
 * GLMoleculeObject_bond.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_BOND_HPP_
#define GLMOLECULEOBJECT_BOND_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer/Observer.hpp"
#include "CodePatterns/ObservedValue.hpp"

#include "LinearAlgebra/Vector.hpp"

#include "Bond/bond.hpp"
#include "types.hpp"

class atom;

class GLWorldScene;

class GLMoleculeObject_bond : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  enum SideOfBond { left, right };

  typedef std::pair<atomId_t, atomId_t> bondIds_t;

  GLMoleculeObject_bond(QGLSceneNode *mesh[], QObject *parent, const bondIds_t bondIds, const enum SideOfBond side);
  virtual ~GLMoleculeObject_bond();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

signals:
  void BondRemoved(const atomId_t leftnr, const atomId_t rightnr);
  void elementChanged();
  void positionChanged();
  void degreeChanged();

private slots:
  //!> grant GLMoleculeObject_molecule acess to reset functions
  friend class GLMoleculeObject_molecule;

  /** Recalculates the element of the cylinder representing the bond.
   *
   */
  void resetElement();

  /** Recalculates the position of the cylinder representing the bond.
   *
   */
  void resetPosition();

  /** Recalculates the width of the cylinder representing the bond's degree.
   *
   */
  void resetWidth();

private:
  /** This must be called from subjectKilled() only.
   *
   * We remove from all other Observables in a controlled manner.
   *
   * removeBond(), and removeChannels() must have been called before (or one of
   * the subjects has been killed).
   *
   */
  void removeMe();
  void removeChannels();

  Vector updateLeftPosition() const;
  Vector updateRightPosition() const;
  atomicNumber_t updateLeftElement() const;
  atomicNumber_t updateRightElement() const;
  int updateDegree() const;

  static const atom * const getAtomConst(const atomId_t _id);
  static atom * const getAtom(const atomId_t _id);

private:
  //!> id of left bond partner for safely emitting BondRemoved signal
  const atomId_t leftatomId;
  //!> id of right bond partner for safely emitting BondRemoved signal
  const atomId_t rightatomId;

  //!> contains ref to Observable of left atom
  const Observable * const leftowner;
  //!> contains ref to Observable of right atom
  const Observable * const rightowner;
  //!> temporary variable used in cstor
  const Observable * const bondowner;

  const enum SideOfBond BondSide;

  ObservedValue<Vector> leftPosition;
  ObservedValue<Vector> rightPosition;
  ObservedValue<atomicNumber_t> leftElement;
  ObservedValue<atomicNumber_t> rightElement;
  ObservedValue<int> Degree;

  //!> indicate whether we are signed in to leftobservable
  bool leftobservable_enabled;
  //!> indicate whether we are signed in to rightobservable
  bool rightobservable_enabled;
  //!> indicate whether we are signed in to bond itself
  bool bond_enabled;

  //!> list of channels when position needs to update
  static const Observable::channels_t BondPositionChannels;
  //!>list of channels when degree needs to update
  static const Observable::channels_t BondDegreeChannels;
  //!> list of channels when element needs to update
  static const Observable::channels_t BondElementChannels;
};



#endif /* GLMOLECULEOBJECT_BOND_HPP_ */
