/*
 * FragmentController.hpp
 *
 *  Created on: Nov 27, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_HPP_
#define FRAGMENTCONTROLLER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"
#include "FragmentJob.hpp"
#include "FragmentResult.hpp"

#include "Controller/CommandRegistry.hpp"

/** The FragmentController sends bunches of jobs to a FragmentScheduler,
 *  waits for their calculation and is called when they are done. Then,
 *  he loads the bunch of results from the Scheduler.
 *
 * While the FragmentScheduler and FragmentWorker rather act on their own
 * this is the piece to implant into the user software to allow for
 * communication with the Server/Worker duo to perform the calculation
 * of the fragments on distant computers.
 */
class FragmentController
{
public:
  FragmentController(boost::asio::io_service& io_service);
  ~FragmentController();

  /// getter for operations exit flag.
  size_t getExitflag() const;

protected:
  /// The Connection to the server.
  Connection connection_;

public:
  /// Registry with all commands of this controller
  CommandRegistry Commands;
};

#endif /* FRAGMENTCONTROLLER_HPP_ */
