/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VectorsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"


TextDialog::VectorsTextQuery::VectorsTextQuery(Parameter<std::vector<Vector> > &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<std::vector<Vector> >(_param, _title,_description)
{}

TextDialog::VectorsTextQuery::~VectorsTextQuery()
{}

bool TextDialog::VectorsTextQuery::handle() {
  std::cout << getDescription() << std::endl;
  char coords[3] = {'x', 'y', 'z'};
  const RealSpaceMatrix &M = World::getInstance().getDomain().getM();
  for (int i=0;i<3;i++)
    std::cout << coords[i] << "[0.." << M.at(i,i) << ( (i!=2) ? "], " : "]: ");

  std::string line;
  getline(std::cin,line);

  // dissect by ","
  double coord = 0.;
  std::string::iterator olditerspace = line.begin();
  std::string::iterator olditercomma = line.begin();
  int counter = 0;
  Vector temp_element;
  for(std::string::iterator vectoriter = line.begin(); vectoriter != line.end(); ++vectoriter) {
    if (*vectoriter == ',')
      counter++;
    if ((*vectoriter == ' ') && (counter == 2)) {
      counter = 0;
      for(std::string::iterator componentiter = olditerspace; (componentiter != vectoriter) && (counter !=3); ++componentiter) {
        if (*componentiter == ',') {
          std::istringstream stream(std::string(componentiter, olditercomma));
          stream >> coord;
          temp_element[counter++] = coord;
          olditercomma = componentiter;
        }
      }
      if ((olditercomma != line.begin()) && (counter != 3)) { // insert last part also
        std::istringstream stream(std::string(olditercomma, vectoriter));
        stream >> coord;
        temp_element[counter++] = coord;
      }
      if (World::getInstance().getDomain().isValid(temp_element))
        temp.push_back(temp_element);
      olditerspace = vectoriter;
    }
  }

  return true;
}

