/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include <cassert>

#include "UIElements/Dialog.hpp"

using namespace std;

Dialog::Dialog()
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->handle();
    // if any query fails (is canceled), we can end the handling process
    if(!retval)
      break;
  }
  if (retval){
    // if all queries succeeded we can set the targets to appropriate values
    for(iter=queries.begin(); iter!=queries.end(); iter++) {
      (*iter)->setResult();
    }
  }
  return retval;
}

/****************** Query types Infrastructure **************************/

// Base class
Dialog::Query::Query(string _title) :
    title(_title)
{}

Dialog::Query::~Query() {}

const std::string Dialog::Query::getTitle() const{
  return title;
}

// Int Queries

Dialog::IntQuery::IntQuery(string title,int *_target) :
    Query(title), target(_target)
{}

Dialog::IntQuery::~IntQuery() {}

void Dialog::IntQuery::setResult() {
  *target = tmp;
}

// String Queries

Dialog::StringQuery::StringQuery(string title,string *_target) :
    Query(title), target(_target)
{}

Dialog::StringQuery::~StringQuery() {};

void Dialog::StringQuery::setResult() {
  *target = tmp;
}

// Molecule Queries

Dialog::MoleculeQuery::MoleculeQuery(string title, molecule **_target, MoleculeListClass *_molecules) :
    Query(title),
    target(_target),
    molecules(_molecules),
    tmp(0)
{}

Dialog::MoleculeQuery::~MoleculeQuery() {}

void Dialog::MoleculeQuery::setResult() {
  *target = tmp;
}
