/*
 * AtomShapeDescriptor.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "AtomShapeDescriptor.hpp"
#include "AtomShapeDescriptor_impl.hpp"

#include "atom.hpp"
#include "Patterns/ObservedContainer_impl.hpp"
#include "Shapes/Shape.hpp"

using namespace std;


AtomShapeDescriptor_impl::AtomShapeDescriptor_impl(Shape _shape) :
  shape(_shape)
{}

AtomShapeDescriptor_impl::~AtomShapeDescriptor_impl()
{}

bool AtomShapeDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom) {
  return shape.isInside(atom.second->getPosition());
}

AtomDescriptor AtomByShape(Shape &_shape){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomShapeDescriptor_impl(_shape)));
}
