/*
 * QtMoleculeItem_formula.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_FORMULA_HPP_
#define QTMOLECULEITEM_FORMULA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include <string>

class QtMoleculeItemFactory;

/** This class contains the formula of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_formula : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_formula(
      QtObservedMolecule::ptr &_ObservedMolecule) :
        QtMoleculeItem(_ObservedMolecule, QtMoleculeItem::NeedsMove)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's formula.
   *
   */
  void internal_updateState()
  {
    setText(QString(ObservedMolecule->getMolFormula().c_str()));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::FORMULA; }
};



#endif /* QTMOLECULEITEM_FORMULA_HPP_ */
