/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtMoleculeItemFactory.cpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "QtMoleculeItemFactory.hpp"

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"
#include "UIElements/Views/Qt4/MoleculeList/SpecificItems/QtMoleculeItem_atomcount.hpp"
#include "UIElements/Views/Qt4/MoleculeList/SpecificItems/QtMoleculeItem_formula.hpp"
#include "UIElements/Views/Qt4/MoleculeList/SpecificItems/QtMoleculeItem_name.hpp"
#include "UIElements/Views/Qt4/MoleculeList/SpecificItems/QtMoleculeItem_occurrence.hpp"
#include "UIElements/Views/Qt4/MoleculeList/SpecificItems/QtMoleculeItem_visibility.hpp"

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Singleton_impl.hpp"

// some attributes need to be easier to find for molecules
// these attributes are skipped so far
const int
QtMoleculeItemFactory::COLUMNCOUNT =
    QtMoleculeItem::COLUMNTYPES_MAX;
const char *
QtMoleculeItemFactory::COLUMNNAMES[QtMoleculeItemFactory::COLUMNCOUNT] =
    {"Name","Visibility", "Atoms","Formula","Occurrence"/*,"Size"*/};

QtMoleculeItemFactory::QtMoleculeItemFactory()
{
}

QList<QStandardItem *>
QtMoleculeItemFactory::createMoleculeItems(
    QtObservedMolecule::ptr &_ObservedMolecule)
{
  QList<QStandardItem *> molItems;
  molItems << new QtMoleculeItem_name(_ObservedMolecule);
  molItems << new QtMoleculeItem_visibility(_ObservedMolecule);
  molItems << new QtMoleculeItem_atomcount(_ObservedMolecule);
  molItems << new QtMoleculeItem_formula(_ObservedMolecule);
  molItems << new QtMoleculeItem_occurrence(_ObservedMolecule);
  return molItems;
}

QList<QStandardItem *>
QtMoleculeItemFactory::createGroupItems(const std::string &_formula)
{
  QList<QStandardItem *> groupItems;
  // fill item list
  QStandardItem *mainitem = new QStandardItem(QString(_formula.c_str()));
  mainitem->setFlags(mainitem->flags() ^ Qt::ItemIsSelectable);
  groupItems << mainitem;

  QStandardItem *visitem = new QStandardItem;
  visitem->setCheckState(Qt::Unchecked);
  visitem->setFlags((visitem->flags() | Qt::ItemIsUserCheckable) ^ Qt::ItemIsSelectable);
  groupItems << visitem;

  QStandardItem *count_item = new QStandardItem(QString(""));
  count_item->setFlags(count_item->flags() ^ Qt::ItemIsSelectable);
  groupItems << count_item;

  QStandardItem *formula_item = new QStandardItem(QString(""));
  formula_item->setFlags(formula_item->flags() ^ Qt::ItemIsSelectable);
  groupItems << formula_item;

  QStandardItem *occ_item = new QStandardItem(QString::number(0));
  occ_item->setFlags(occ_item->flags() ^ Qt::ItemIsSelectable);
  groupItems << occ_item;

  return groupItems;
}

CONSTRUCT_SINGLETON(QtMoleculeItemFactory)
