/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtMoleculeItem.cpp
 *
 *  Created on: Jan 17, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "QtMoleculeItem.hpp"

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeList.hpp"

#include "CodePatterns/MemDebug.hpp"

QtMoleculeItem::QtMoleculeItem(
    QtObservedMolecule::ptr &_ObservedMolecule,
     const enum MoveTypes _movetype) :
  ObservedMolecule(_ObservedMolecule),
  movetype(_movetype),
  dirty(true)
{
  setFlags(flags() | Qt::ItemIsSelectable);
}

QtMoleculeItem::~QtMoleculeItem()
{
}

void QtMoleculeItem::updateState()
{
  if (dirty) {
    internal_updateState();
    dirty = false;
  }
}
