/*
 * QtGeometryList.hpp
 *
 *  Created on: Mar 25, 2017
 *      Author: heber
 */

#ifndef QTGEOMETRYLIST_H_
#define QTGEOMETRYLIST_H_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include <QMouseEvent>

#include "CodePatterns/Observer/Observer.hpp"

class GeometryObject;

class QtGeometryList: public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtGeometryList(QWidget * _parent=0);
  virtual ~QtGeometryList();

protected:
  bool eventFilter(QObject* object, QEvent* event);
  void mouseMoveFunction(QMouseEvent * event);

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  //virtual void paintEvent(QPaintEvent * event);
  void refill(::GeometryObject *ignore);

  static const int COLUMNCOUNT;
  enum {NAME,VECTOR,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

};

#endif /* QTGEOMETRYLIST_H_ */
