/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VectorsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Geometry/GeometryRegistry.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"


TextDialog::VectorsTextQuery::VectorsTextQuery(Parameter<std::vector<Vector> > &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<std::vector<Vector> >(_param, _title,_description)
{}

TextDialog::VectorsTextQuery::~VectorsTextQuery()
{}

bool TextDialog::VectorsTextQuery::handle() {
  std::stringstream output;
  std::cout << getDescription() << std::endl;
  char coords[3] = {'x', 'y', 'z'};
  const RealSpaceMatrix &M = World::getInstance().getDomain().getM();
  std::cout << "Enter three comma-separated coordinates, vector name, ? for list or empty for end." << std::endl;
  while (true) {
    for (int i=0;i<3;i++)
      std::cout << coords[i] << "[0.." << M.at(i,i) << ( (i!=2) ? "], " : "]: ");

    std::string line;
    getline(std::cin,line);

    if (line == "?") {
      GeometryRegistry &reg = GeometryRegistry::getInstance();

      GeometryRegistry::const_iterator iter;
      for (iter = reg.getBeginIter(); iter != reg.getEndIter(); iter ++){
        GeometryObject *v = iter->second;
        std::cout << "\t" << *v << std::endl;
      }
    } else if (line.empty()) {
      break;
    } else {
      // simply append with white-space delimiter
      temp.push_back(line);
    }
  }

  return true;
}

