/*
 * TextQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef TEXTQUERY_HPP_
#define TEXTQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "TextUI/TextDialog.hpp"

class TextDialog::EmptyTextQuery : public Dialog::EmptyQuery {
public:
  EmptyTextQuery(const std::string &_title, const std::string &_description = NULL);
  virtual ~EmptyTextQuery();
  virtual bool handle();
};

class TextDialog::VectorTextQuery : public Dialog::TQuery<Vector> {
public:
  VectorTextQuery(Parameter<Vector> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~VectorTextQuery();
  virtual bool handle();
};

class TextDialog::VectorsTextQuery : public Dialog::TQuery< std::vector<Vector> > {
public:
  VectorsTextQuery(Parameter< std::vector<Vector> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~VectorsTextQuery();
  virtual bool handle();
};

  /** With the following boost::preprocessor code we generate forward declarations
   * of query class for all desired query types in the Qt specialization class of
   * Dialog.
   */
#include "UIElements/GlobalListOfParameterQueries.hpp"
#include "UIElements/Dialog_impl_pre.hpp"

  #include <boost/preprocessor/facilities/empty.hpp>

  // iterate over all parameter query types for forward declarations
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define BOOST_PP_LOCAL_MACRO(n) queryclass_definition(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, GLOBALLISTOFPARAMETERQUERIES_Type, Text)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #undef queryclass_definition
  #endif

#include "Dialog_impl_undef.hpp"
  /* End of preprocessor code piece */


#endif /* TEXTQUERY_HPP_ */
