/*
 * QtQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef QTQUERY_HPP_
#define QTQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <Qt/qwidget.h>
#include "Qt4/QtDialog.hpp"
#include "QtQueryList.hpp"

#include "Parameters/Parameter.hpp"

class QHBoxLayout;
class QBoxLayout;
class QDialogButtonBox;
class QLabel;
class QSpinBox;
class QDoubleSpinBox;
class QLineEdit;
class QListWidget;
class QPushButton;
class QTableWidget;
class QTextEdit;
class QComboBox;
class QCheckBox;
class QFileDialog;

template<class T>
class QtQuery : public Dialog::TQuery<T>
{
public:
  QtQuery(Parameter<T> &_param, const std::string &_title, const std::string &_description = "") :
    Dialog::TQuery<T>(_param, _title, _description) {}
  // QtQueries are interactive - no need for handle().
  virtual bool handle(){  return true;  }
};

class QtDialog::AtomQtQuery : public QWidget, public QtQuery<const atom *> {
  Q_OBJECT
public:
  AtomQtQuery(Parameter<const atom *> &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~AtomQtQuery();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::AtomsQtQuery : public QWidget, public QtQuery<std::vector<const atom *> >, public QtQueryList<const atom *> {
  Q_OBJECT
public:
  AtomsQtQuery(Parameter<std::vector<const atom *> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~AtomsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  AtomQtQuery *subQuery;
};

class QtDialog::BooleanQtQuery : public QWidget, public QtQuery<bool> {
  Q_OBJECT
public:
  BooleanQtQuery(Parameter<bool> &, const std::string &_title, const std::string &description, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~BooleanQtQuery();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QCheckBox *booleanCheckBox;
  Dialog *dialog;
};

class QtDialog::RealSpaceMatrixQtQuery : public QWidget, public QtQuery<RealSpaceMatrix> {
  Q_OBJECT
public:
  RealSpaceMatrixQtQuery(Parameter<RealSpaceMatrix> &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~RealSpaceMatrixQtQuery();

public slots:
  void onUpdate(int, int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QTableWidget *inputTable;
  Dialog *dialog;
};

class QtDialog::DoubleQtQuery : public QWidget, public QtQuery<double> {
  Q_OBJECT
public:
  DoubleQtQuery(Parameter<double> &, const std::string &_title, const std::string &_description,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~DoubleQtQuery();

public slots:
  void onUpdate(double);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QDoubleSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::DoublesQtQuery : public QWidget, public QtQuery<std::vector<double> >, public QtQueryList<double> {
  Q_OBJECT
public:
  DoublesQtQuery(Parameter<std::vector<double> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~DoublesQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  DoubleQtQuery *subQuery;
};

class QtDialog::ElementQtQuery : public QWidget, public QtQuery<const element *> {
  Q_OBJECT
public:
  ElementQtQuery(Parameter<const element *> &, const std::string &_title, const std::string &description, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~ElementQtQuery();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::ElementsQtQuery : public QWidget, public QtQuery<std::vector<const element *> >, public QtQueryList<const element *> {
  Q_OBJECT
public:
  ElementsQtQuery(Parameter<std::vector<const element *> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~ElementsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  ElementQtQuery *subQuery;
};

class QtDialog::EmptyQtQuery : public Dialog::EmptyQuery {
public:
  EmptyQtQuery(const std::string &_title, const std::string &description, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~EmptyQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  Dialog *dialog;
};

class QtDialog::FileQtQuery : public QWidget, public QtQuery<boost::filesystem::path> {
  Q_OBJECT
public:
  FileQtQuery(Parameter<boost::filesystem::path> &, const std::string &_title, const std::string &description, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~FileQtQuery();

public slots:
  void onUpdate();
  void showFileDialog();

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *filenameLabel;
  QLineEdit *filenameLineEdit;
  QPushButton *filedialogButton;
  QFileDialog *theFileDialog;
  Dialog *dialog;
  std::vector<std::string> suffixes;
  bool mustBePresent;
};

class QtDialog::FilesQtQuery : public QWidget, public QtQuery<std::vector<boost::filesystem::path> >, public QtQueryList<boost::filesystem::path> {
  Q_OBJECT
public:
  FilesQtQuery(Parameter<std::vector<boost::filesystem::path> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~FilesQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  FileQtQuery *subQuery;
};

class QtDialog::IntQtQuery : public QWidget, public QtQuery<int> {
  Q_OBJECT
public:
  IntQtQuery(Parameter<int> &, const std::string &_title, const std::string &description,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~IntQtQuery();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::IntsQtQuery : public QWidget, public QtQuery<std::vector<int> >, public QtQueryList<int> {
  Q_OBJECT
public:
  IntsQtQuery(Parameter<std::vector<int> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~IntsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  IntQtQuery *subQuery;
};

class QtDialog::MoleculeQtQuery : public QWidget, public QtQuery<const molecule *> {
  Q_OBJECT
public:
  MoleculeQtQuery(Parameter<const molecule *> &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~MoleculeQtQuery();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::MoleculesQtQuery : public QWidget, public QtQuery<std::vector<const molecule *> >, public QtQueryList<const molecule *> {
  Q_OBJECT
public:
  MoleculesQtQuery(Parameter<std::vector<const molecule *> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~MoleculesQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  MoleculeQtQuery *subQuery;
};

class QtDialog::KeyValuePairQtQuery : public QWidget, public QtQuery<KeyValuePair> {
  Q_OBJECT
public:
  KeyValuePairQtQuery(Parameter<KeyValuePair> &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~KeyValuePairQtQuery();

public slots:
  void onUpdate(const QString&);
  void onUpdateCombo(int index);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLineEdit *inputBox;
  QComboBox *comboBox;
  Dialog *dialog;
};

class QtDialog::KeyValuePairsQtQuery : public QWidget, public QtQuery<std::vector<KeyValuePair> >, public QtQueryList<KeyValuePair> {
  Q_OBJECT
public:
  KeyValuePairsQtQuery(Parameter<std::vector<KeyValuePair> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~KeyValuePairsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  KeyValuePairQtQuery *subQuery;
};

class QtDialog::StringQtQuery : public QWidget, public QtQuery<std::string> {
  Q_OBJECT
public:
  StringQtQuery(Parameter<std::string> &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~StringQtQuery();

public slots:
  void onUpdate(const QString&);
  void onUpdateCombo(int index);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLineEdit *inputBox;
  QComboBox *comboBox;
  Dialog *dialog;
};

class QtDialog::StringsQtQuery : public QWidget, public QtQuery<std::vector<std::string> >, public QtQueryList<std::string> {
  Q_OBJECT
public:
  StringsQtQuery(Parameter<std::vector<std::string> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~StringsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  StringQtQuery *subQuery;
};

class QtDialog::UnsignedIntQtQuery : public QWidget, public QtQuery<unsigned int> {
  Q_OBJECT
public:
  UnsignedIntQtQuery(Parameter<unsigned int> &, const std::string &_title, const std::string &description,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~UnsignedIntQtQuery();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::UnsignedIntsQtQuery : public QWidget, public QtQuery<std::vector<unsigned int> >, public QtQueryList<unsigned int> {
  Q_OBJECT
public:
  UnsignedIntsQtQuery(Parameter<std::vector<unsigned int> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~UnsignedIntsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  UnsignedIntQtQuery *subQuery;
};

class QtDialog::VectorQtQuery : public QWidget, public QtQuery<Vector> {
  Q_OBJECT
public:
  VectorQtQuery(Parameter<Vector> &, const std::string &_title, const std::string &_description,QBoxLayout *,Dialog *);
  virtual ~VectorQtQuery();

public slots:
  void pageChanged(int);
  void onUpdateName(int);
  void onUpdateX(double);
  void onUpdateY(double);
  void onUpdateZ(double);

private:
  QBoxLayout *parent;
  QBoxLayout *mainLayout;
  QLabel *titleLabel;
  QBoxLayout *subLayout;
  QBoxLayout *coordLayout;
  QDoubleSpinBox *coordInputX;
  QDoubleSpinBox *coordInputY;
  QDoubleSpinBox *coordInputZ;
  Dialog *dialog;
  QBoxLayout *nameLayout;
  QComboBox *nameComboBox;
};

class QtDialog::VectorsQtQuery :
    public QWidget,
    public QtQuery<std::vector<Vector> >,
    public QtQueryList<Vector> {
  Q_OBJECT
public:
  VectorsQtQuery(Parameter<std::vector<Vector> > &, const std::string &_title, const std::string &description, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~VectorsQtQuery();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  VectorQtQuery *subQuery;
};

#endif /* QTQUERY_HPP_ */
