/*
 * QtDialog.hpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

#ifndef QTDIALOG_HPP_
#define QTDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QObject>

#include "Parameters/Parameter.hpp"
#include "UIElements/Dialog.hpp"
#include <QtGui/QDialog>

#include <map>
#include <set>
#include <vector>

class QBoxLayout;
class QDialogButtonBox;

class QtDialog : public QDialog, public Dialog
{
  Q_OBJECT
public:
  QtDialog(const std::string &_title);
  virtual ~QtDialog();

  virtual void queryEmpty(const std::string ="", const std::string = "");

  virtual void queryVector(Parameter<Vector> &, const std::string ="", const std::string = "");
  virtual void queryVectors(Parameter< std::vector<Vector> > &, const std::string ="", const std::string = "");

  /** With the following boost::preprocessor code we generate virtual function
   * definitions for all desired query types in the abstract class Dialog.
   */
#include "UIElements/GlobalListOfParameterQueries.hpp"
#include "UIElements/Dialog_impl_pre.hpp"

  #include <boost/preprocessor/facilities/empty.hpp>

  // iterate over all parameter query types
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define SUFFIX BOOST_PP_EMPTY()
  #define BOOST_PP_LOCAL_MACRO(n) dialog_declaration(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, GLOBALLISTOFPARAMETERQUERIES_Type)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #undef dialog_declaration
  #undef SUFFIX
  #endif

#include "Dialog_impl_undef.hpp"
  /* End of preprocessor code piece */

  virtual bool display();

  virtual void update();

protected:

  class EmptyQtQuery;

  class VectorQtQuery;
  class VectorsQtQuery;

  /** With the following boost::preprocessor code we generate forward declarations
   * of query class for all desired query types in the Qt specialization class of
   * Dialog.
   */
#include "UIElements/GlobalListOfParameterQueries.hpp"
#include "UIElements/Dialog_impl_pre.hpp"

  #include <boost/preprocessor/facilities/empty.hpp>

  // iterate over all parameter query types for forward declarations
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define BOOST_PP_LOCAL_MACRO(n) forward_declaration(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, QtQuery)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #undef forward_declaration
  #endif

#include "Dialog_impl_undef.hpp"
  /* End of preprocessor code piece */

private:
  QBoxLayout *mainLayout;
  QBoxLayout *inputLayout;
  QBoxLayout *buttonLayout;
  QDialogButtonBox *buttons;
};


#endif /* QTDIALOG_HPP_ */
