/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Dialog.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Parameters/ParameterExceptions.hpp"

class Atom;
class element;
class RealSpaceMatrix;
class molecule;
class Vector;

using namespace std;

Dialog::Dialog(const std::string &_title)
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  handleAll();
  setAll();
  return true;
//  if(checkAll()){
//    setAll();
//    return true;
//  }
//  else{
//    return false;
//  }
}

void Dialog::handleAll(){
  list<Query*>::iterator iter;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    try{
      (*iter)->handle();
    }catch(...){
    // if any query fails (is canceled), we can end the handling process
      ELOG(1, "The following query failed: " << (**iter).getTitle() << ".");
      break;
    }
  }
}

bool Dialog::checkAll(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->isValid();
    // if any query fails (is canceled), we can end the handling process
    if(!retval) {
      ELOG(1, "The following query failed: " << (**iter).getTitle() << ".");
      break;
    }
  }
  return retval;
}

void Dialog::setAll(){
  list<Query*>::iterator iter;
  for(iter=queries.begin(); iter!=queries.end(); iter++) {
//    try {
      (*iter)->setResult();
//    } catch (ParameterException &e) {
//      if( const std::string *name=boost::get_error_info<ParameterName>(e) )
//        ELOG(1, "The following parameter value is not valid: " << *name << ".");
//      break;
//    }
  }
}

bool Dialog::hasQueries(){
  list<Query*>::iterator iter;
  size_t nonemptyQueries = 0;
  for(iter=queries.begin(); iter!=queries.end(); iter++) {
    // count all queries that not EmptyQuery
    if (dynamic_cast<Dialog::EmptyQuery *>(*iter) == NULL)
      ++nonemptyQueries;
  }
  return nonemptyQueries != 0;
}

/*template <> void Dialog::query<Dialog::EmptyType>(Parameter<Dialog::EmptyType> &param, const std::string title, const std::string description)
{
  queryEmpty(param, title, description);
}*/
template <>
void Dialog::query<Vector>(Parameter<Vector> &param, const std::string title, const std::string description)
{
  queryVector(param, title, description);
}
template <>
void Dialog::query< std::vector<Vector> >(Parameter< std::vector<Vector> > &param, const std::string title, const std::string description)
{
  queryVectors(param, title, description);
}

static const std::string concatenateStrings(const std::vector<std::string> &_strings)
{
  std::stringstream output;
  for (std::vector<std::string>::const_iterator iter = _strings.begin();
      iter != _strings.end(); ++iter)
    output << *iter << " ";
  return output.str();
}

bool Dialog::TQuery< std::vector<Vector> >::isValid()
{
  return param.isValidAsString(concatenateStrings(temp));
}
void Dialog::TQuery< std::vector<Vector> >::setResult()
{
  param.setAsString(concatenateStrings(temp));
}

/** With the following boost::preprocessor code we generate template
 * specializations for each desired query types in the abstract class Dialog.
 */
#include "UIElements/GlobalListOfParameterQueries.hpp"
#include "UIElements/Dialog_impl_pre.hpp"

  // print a template body
  #define dialog_definition(z,n,TOKENLIST,TYPELIST) \
  template <> void Dialog::query< \
    BOOST_PP_SEQ_ELEM(n, TYPELIST) \
  >(Parameter< \
    BOOST_PP_SEQ_ELEM(n, TYPELIST) \
  > &param, const std::string title, const std::string description) { \
  BOOST_PP_CAT(query, BOOST_PP_SEQ_ELEM(n, TOKENLIST)) \
  (param, title, description); }

  // print template specialization for every query type
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define BOOST_PP_LOCAL_MACRO(n) dialog_definition(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, GLOBALLISTOFPARAMETERQUERIES_Type)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #endif

  #undef dialog_definition

#include "Dialog_impl_undef.hpp"
/* End of preprocessor code piece */

//template <> void Dialog::query< std::vector<KeyValuePair> >(Parameter< std::vector<KeyValuePair> > &param, const std::string title, const std::string description)
//{
//  queryKeyValuePairs(param, title, description);
//}

/************************** Query Infrastructure ************************/
/*       ---> shifted to folder Query                                   */
/************************************************************************/
