/*
 * CommandLineDialog.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEDIALOG_HPP_
#define COMMANDLINEDIALOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>

class atom;
class element;
class molecule;
class Vector;

#include "Dialog.hpp"

/** CommandLineUIFactory implementation of the Dialog.
 * The idea here is that for each query the parsed command line options are used instead.
 */
class CommandLineDialog : public Dialog
{
public:
  CommandLineDialog(const std::string &_title);
  virtual ~CommandLineDialog();

  virtual void queryEmpty(const std::string ="", const std::string = "");

protected:

  class EmptyCommandLineQuery;

  /** With the following boost::preprocessor code we generate virtual function
   * definitions and forward declarations for all desired query types in the
   * CommandLineUI specialization of class Dialog.
   */
#include "UIElements/GlobalListOfParameterQueries.hpp"
#include "UIElements/Dialog_impl_pre.hpp"

  #include <boost/preprocessor/facilities/empty.hpp>

  virtual void queryVector(Parameter<Vector> &, const std::string ="", const std::string = "");
  virtual void queryVectors(Parameter< std::vector<Vector> > &, const std::string ="", const std::string = "");

  // iterate over all parameter query types for query declarations
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define SUFFIX BOOST_PP_EMPTY()
  #define BOOST_PP_LOCAL_MACRO(n) dialog_declaration(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, GLOBALLISTOFPARAMETERQUERIES_Type)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #undef dialog_declaration
  #undef SUFFIX
  #endif

  class VectorCommandLineQuery;
  class VectorsCommandLineQuery;

  // iterate over all parameter query types for forward declarations
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define BOOST_PP_LOCAL_MACRO(n) forward_declaration(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, CommandLineQuery)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #undef forward_declaration
  #endif

#include "Dialog_impl_undef.hpp"
  /* End of preprocessor code piece */

};

#endif /* COMMANDLINEDIALOG_HPP_ */
