/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentJobUnitTest.cpp
 *
 *  Created on: Oct 23, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "FragmentJobUnitTest.hpp"

#include "FragmentJob.hpp"
#include "FragmentResult.hpp"
#include "JobId.hpp"

#include "CodePatterns/Assert.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( FragmentJobTest );


void FragmentJobTest::setUp()
{
  // Throw assertions
  ASSERT_DO(Assert::Throw);

  command = std::string("/bin/true");
  outputfile = std::string("do something");
}


void FragmentJobTest::tearDown()
{
}

/** UnitTest for operator==
 */
void FragmentJobTest::equalityTest()
{
  FragmentJob::ptr testJob(new FragmentJob(command, outputfile, 1));
  FragmentJob::ptr sameIdJob(new FragmentJob(command, outputfile, 1));
  FragmentJob::ptr otherIdJob(new FragmentJob(command, outputfile, 2));
  FragmentJob::ptr copiedJob(new FragmentJob(*testJob));
  FragmentJob::ptr copiedchangedJob(new FragmentJob(*testJob));
  copiedchangedJob->setId(3);

  CPPUNIT_ASSERT( *testJob == *sameIdJob );
  CPPUNIT_ASSERT( *testJob != *otherIdJob );
  CPPUNIT_ASSERT( *testJob == *copiedJob );
  CPPUNIT_ASSERT( *testJob != *copiedchangedJob );
}

/** UnitTest for Work()
 */
void FragmentJobTest::WorkTest()
{
  FragmentJob::ptr testJob(new FragmentJob(command, outputfile, 1));
  FragmentJob::ptr othertestJob(new FragmentJob(command, outputfile, 2));

  FragmentResult testResult(testJob->Work());
  FragmentResult othertestResult(othertestJob->Work());

  CPPUNIT_ASSERT_EQUAL( (JobId_t)1, testResult.getId() );
  CPPUNIT_ASSERT_EQUAL( (JobId_t)2, othertestResult.getId() );
}

/** UnitTest for serialization
 */
void FragmentJobTest::serializationTest()
{
  FragmentJob::ptr testJob(new FragmentJob(command, outputfile, 1));
  // write element to stream
  std::stringstream stream;
  boost::archive::text_oarchive oa(stream);
  oa << testJob;

  //std::cout << "Contents of archive is " << stream.str() << std::endl;

  // create and open an archive for input
  boost::archive::text_iarchive ia(stream);
  // read class state from archive
  FragmentJob::ptr otherJob;

  ia >> otherJob;

  CPPUNIT_ASSERT (*testJob == *otherJob);
}

