/*
 * FragmentQueue.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTQUEUE_HPP_
#define FRAGMENTQUEUE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <deque>
#include <map>
#include <vector>

#include "types.hpp"
#include "FragmentJob.hpp"
#include "FragmentResult.hpp"

class FragmentQueueTest;

/** This class contains a deque for temporarily storing the FragmentJob
 * instances until they are received by the server. Also all results are
 * contained herein.
 */
class FragmentQueue
{
  friend class FragmentQueueTest;
public:
  FragmentQueue();
  ~FragmentQueue();

  // entering jobs into queue
  void pushJob(FragmentJob::ptr job);
  void pushJobs(std::vector<FragmentJob::ptr> &_jobs);
  FragmentJob::ptr popJob();
  bool isJobPresent() const;

  // querying for results
  bool isResultPresent(JobId_t jobid) const;
  FragmentResult getResult(JobId_t jobid);
  void pushResult(FragmentResult &_result);
  std::vector<FragmentResult> getAllResults();

  size_t getDoneJobs() const;

private:
  bool isPresentResult(const FragmentResult &_result) const;

  //!> result that takes place in ResultQueue after job has arrived before it has been popped.
  static FragmentResult NoResult;
  //!> result that takes place in ResultQueue until real result has arrived.
  static FragmentResult NoResultQueued;
  //!> result that takes place in ResultQueue after real result has been delivered.
  static FragmentResult ResultDelivered;

  typedef std::deque<FragmentJob::ptr> JobQueue;
  typedef std::map<JobId_t, FragmentResult> ResultMap;

  //!> queue for all jobs
  JobQueue jobs;
  //!> map for all results that have been polled by the server
  ResultMap results;
};


#endif /* FRAGMENTQUEUE_HPP_ */
