/*
 * TextWindow.hpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#ifndef TEXTWINDOW_HPP_
#define TEXTWINDOW_HPP_

#include "MainWindow.hpp"

#include <string>
#include <set>

class TextMenu;
class Action;
class StringView;
class TextStatusIndicator;


class TextWindow : public MainWindow
{
public:
  TextWindow();
  virtual ~TextWindow();

  virtual void display();

private:
  // populaters
  char getSuitableShortForm(std::set <char> &ShortcutList, const std::string name) const;
  void populateMenu(TextMenu* Menu, const std::string &name);

  TextMenu *main_menu;

  // some actions only needed in textMenus
  Action *quitAction;
  // all views that are contained in the main Menu
  StringView *moleculeView;
  TextStatusIndicator *statusIndicator;
};

#endif /* TEXTWINDOW_HPP_ */
