/*
 * TextDialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef TEXTDIALOG_HPP_
#define TEXTDIALOG_HPP_

#include <string>

#include "Dialog.hpp"

class atom;
class element;
class molecule;
class Vector;

class TextDialog : public Dialog
{
public:
  TextDialog();
  virtual ~TextDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryBoolean(const char *, bool *, std::string = "");
  virtual void queryInt(const char *, int *, std::string = "");
  virtual void queryString(const char*, std::string *, std::string = "");
  virtual void queryStrings(const char*, std::vector<std::string> *, std::string = "");
  virtual void queryDouble(const char*, double*, std::string = "");
  virtual void queryAtom(const char*,atom**,std::string = "");
  virtual void queryMolecule(const char*,molecule**,std::string = "");
  virtual void queryVector(const char*,Vector *,bool, std::string = "");
  virtual void queryBox(const char*,Box*, std::string = "");
  virtual void queryElement(const char*, std::vector<element *> *, std::string = "");

protected:
  // specialized stuff for text queries
  class EmptyTextQuery : public Dialog::EmptyQuery {
  public:
    EmptyTextQuery(std::string title, std::string _description = NULL);
    virtual ~EmptyTextQuery();
    virtual bool handle();
  };

  class BooleanTextQuery : public Dialog::BooleanQuery {
  public:
    BooleanTextQuery(std::string title, bool *_target, std::string _description = NULL);
    virtual ~BooleanTextQuery();
    virtual bool handle();
  };

  class IntTextQuery : public Dialog::IntQuery {
  public:
    IntTextQuery(std::string title, int *_target, std::string _description = NULL);
    virtual ~IntTextQuery();
    virtual bool handle();
  };

  class DoubleTextQuery : public Dialog::DoubleQuery {
  public:
    DoubleTextQuery(std::string title, double *_target, std::string _description = NULL);
    virtual ~DoubleTextQuery();
    virtual bool handle();
  };

  class StringTextQuery : public Dialog::StringQuery {
  public:
    StringTextQuery(std::string title, std::string *_target, std::string _description = NULL);
    virtual ~StringTextQuery();
    virtual bool handle();
  };

  class StringsTextQuery : public Dialog::StringsQuery {
  public:
    StringsTextQuery(std::string title, std::vector<std::string> *_target, std::string _description = NULL);
    virtual ~StringsTextQuery();
    virtual bool handle();
  };

  class AtomTextQuery : public Dialog::AtomQuery {
  public:
    AtomTextQuery(std::string title, atom **_target, std::string _description = NULL);
    virtual ~AtomTextQuery();
    virtual bool handle();
  };

  class MoleculeTextQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeTextQuery(std::string title, molecule **_target, std::string _description = NULL);
    virtual ~MoleculeTextQuery();
    virtual bool handle();
  };

  class VectorTextQuery : public Dialog::VectorQuery {
  public:
    VectorTextQuery(std::string title,Vector *_target,bool _check, std::string _description = NULL);
    virtual ~VectorTextQuery();
    virtual bool handle();
  };

  class BoxTextQuery : public Dialog::BoxQuery {
  public:
    BoxTextQuery(std::string title,Box* _cellSize, std::string _description = NULL);
    virtual ~BoxTextQuery();
    virtual bool handle();
  };

  class ElementTextQuery : public Dialog::ElementQuery {
  public:
    ElementTextQuery(std::string title, std::vector<element *> *_target, std::string _description = NULL);
    virtual ~ElementTextQuery();
    virtual bool handle();
  };
};

#endif /* TEXTDIALOG_HPP_ */
