/*
 * QTMainWindow.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#include "QTMainWindow.hpp"

#include<Qt/qapplication.h>
#include<Qt/qlabel.h>
#include<Qt/qstring.h>
#include<Qt/qmenubar.h>
#include<Qt/qsplitter.h>

#include<iostream>
#include<map>

#include<boost/bind.hpp>

#include "atom.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/MapOfActions.hpp"
#include "Menu/Menu.hpp"
#include "Menu/QT4/QTMenu.hpp"
#include "Menu/ActionMenuItem.hpp"
#include "Views/QT4/QTWorldView.hpp"
#include "Views/QT4/GLMoleculeView.hpp"
#include "Views/QT4/QTMoleculeView.hpp"
#include "Views/QT4/QTStatusBar.hpp"
#include "Helpers/MemDebug.hpp"


using namespace std;

QTMainWindow::QTMainWindow(QApplication *_theApp) :
    theApp(_theApp)
{
  QSplitter *splitter1 = new QSplitter (Qt::Horizontal, this );
  QSplitter *splitter2 = new QSplitter (Qt::Vertical, splitter1 );

  worldDisplay = new QTWorldView(splitter2);

  moleculeDisplay = new QTMoleculeView();
  molecule3dDisplay = new GLMoleculeView();

  MenuBar = menuBar();

  std::map <std::string, QTMenu *> NametoTextMenuMap;
  // go through all menus and create them
  QTMenu *Menu = NULL;
  for(std::map<std::string, std::pair<std::string,std::string> >::iterator iter = MapOfActions::getInstance().MenuDescription.begin(); iter != MapOfActions::getInstance().MenuDescription.end(); ++iter) {
    cout << "Creating menu " << iter->first << endl;
    Menu = new QTMenu(iter->first.c_str());
    MenuBar->addMenu(Menu);
    NametoTextMenuMap.insert( pair <std::string, QTMenu *> (iter->first, Menu) );
    //new SubMenuItem(getSuitableShortForm(iter->first),iter->second.first,main_menu,Menu);
  }

  // populate all actions
  MapOfActions::getInstance().populateActions();

  // go through all actions and add them to its menu
  for (std::map <std::string, QTMenu *>::iterator MenuRunner = NametoTextMenuMap.begin(); MenuRunner != NametoTextMenuMap.end(); ++MenuRunner) {
    cout << "Creating Action " << MenuRunner->first << " in menu " << MenuRunner->second << endl;
    populateMenu(MenuRunner->second, MenuRunner->first);
  }

  setCentralWidget(splitter1);
  splitter1->addWidget(splitter2);
  splitter1->addWidget(moleculeDisplay);
  splitter2->addWidget(molecule3dDisplay);
  splitter2->addWidget(worldDisplay);

  statusBar = new QTStatusBar(this);
  setStatusBar(statusBar);

  connect(worldDisplay,SIGNAL(moleculeSelected(molecule*)),moleculeDisplay,SLOT(moleculeSelected(molecule*)));
  connect(worldDisplay,SIGNAL(moleculeUnSelected(molecule*)),moleculeDisplay,SLOT(moleculeUnSelected(molecule*)));
}

QTMainWindow::~QTMainWindow()
{
  menuBar()->clear();
  delete editMoleculesMenu;
}

void QTMainWindow::display() {
  this->show();
  theApp->exec();
}

char QTMainWindow::getSuitableShortForm(set <char> &ShortcutList, const std::string name) const
{
  for (std::string::const_iterator CharRunner = name.begin(); CharRunner != name.end(); ++CharRunner) {
    if (ShortcutList.find(*CharRunner) == ShortcutList.end())
      return *CharRunner;
  }
  DoeLog(1) && (eLog() << Verbose(1) << "Could not find a suitable shortform for TextWindow::getSuitableShortForm()." << endl);
  return ((char)(ShortcutList.size() % 10) + '0');
}

void QTMainWindow::populateMenu(QTMenu* Menu, const  std::string &MenuName)
{
  Action *ActionItem = NULL;
  set <char> ShortcutList;
  // through all actions for this menu
  std::pair < std::multimap <std::string, std::string>::iterator, std::multimap <std::string, std::string>::iterator > MenuActions = MapOfActions::getInstance().MenuContainsActionMap.equal_range(MenuName);
  for (std::multimap <std::string, std::string>::const_iterator MenuRunner = MenuActions.first; MenuRunner != MenuActions.second; ++MenuRunner) {
    cout << " Adding " << MenuRunner->second << " to submenu " << MenuName << endl;
    ActionItem = ActionRegistry::getInstance().getActionByName(MenuRunner->second);
    new ActionMenuItem(getSuitableShortForm(ShortcutList, MenuRunner->second),MapOfActions::getInstance().getDescription(MenuRunner->second).c_str(),Menu,ActionItem);
  }
  // finally add default quit item
  //Action *returnFromAction = new TextMenu::LeaveAction(Menu);
  //MenuItem *returnFromItem = new ActionMenuItem('q',"return to Main menu",Menu,returnFromAction);
  //Menu->addDefault(returnFromItem);
}
