/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * \file ResultGetter.cpp
 *
 * This file strongly follows the Serialization example from the boost::asio
 * library (see client.cpp)
 *
 *  Created on: Nov 27, 2011
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <vector>

#include "atexit.hpp"
#include "CodePatterns/Info.hpp"
#include "CodePatterns/Log.hpp"
#include "FragmentController.hpp"
#include "FragmentJob.hpp"
#include "FragmentResult.hpp"


int main(int argc, char* argv[])
{
  // from this moment on, we need to be sure to deeinitialize in the correct order
  // this is handled by the cleanup function
  atexit(cleanUp);

  setVerbosity(3);

  size_t Exitflag = 0;
  try
  {
    // Check command line arguments.
    if (argc != 3)
    {
      std::cerr << "Usage: " << argv[0] << " <host> <port>" << std::endl;
      return 1;
    }

    boost::asio::io_service io_service;
    FragmentController controller(io_service, argv[1], argv[2]);

    std::vector<FragmentJob> jobs;
    {
      FragmentJob testJob(std::string("do something"), 1);
      FragmentJob othertestJob(std::string("do something else"), 2);
      jobs.push_back(testJob);
      jobs.push_back(othertestJob);
    }

    controller.obtainResults();
    {
      Info info("io_service");
      io_service.run();
    }
    std::vector<FragmentResult> results = controller.getResults();
    for (std::vector<FragmentResult>::const_iterator iter = results.begin();
        iter != results.end(); ++iter)
      LOG(1, "RESULT: job #"+toString((*iter).getId())+": "+toString((*iter).result));
    Exitflag = controller.getExitflag();
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }

  return Exitflag;
}
