/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculesCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::MoleculesCommandLineQuery::MoleculesCommandLineQuery(Parameter<std::vector<const molecule *> > &param, std::string title, std::string _description) :
    Dialog::MoleculesQuery(param, title, _description)
{}

CommandLineDialog::MoleculesCommandLineQuery::~MoleculesCommandLineQuery() {}

bool CommandLineDialog::MoleculesCommandLineQuery::handle() {
  std::vector<int> IdxOfMol;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    IdxOfMol = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    std::vector<const molecule *> temp_molecules;
    for (std::vector<int>::iterator iter = IdxOfMol.begin(); iter != IdxOfMol.end(); ++iter) {
      temp = World::getInstance().getMolecule(MoleculeById(*iter));
      if (temp)
        temp_molecules.push_back(temp);
    }
    tmp.set(temp_molecules);
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing molecules for " << getTitle() << ".");
    return false;
  }
}

