/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FileCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::FileCommandLineQuery::FileCommandLineQuery(Parameter<boost::filesystem::path> &param, std::string title, std::string _description) :
    Dialog::FileQuery(param, title, _description)
{}

CommandLineDialog::FileCommandLineQuery::~FileCommandLineQuery() {}

bool CommandLineDialog::FileCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp.set(CommandLineParser::getInstance().vm[getTitle()].as< boost::filesystem::path >());
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing string for " << getTitle() << ".");
    return false;
  }
}

