/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

CommandLineDialog::ElementsCommandLineQuery::ElementsCommandLineQuery(Parameter<std::vector<const element*> > &param, std::string title, std::string _description) :
    Dialog::ElementsQuery(param, title, _description)
{}

CommandLineDialog::ElementsCommandLineQuery::~ElementsCommandLineQuery()
{}

bool CommandLineDialog::ElementsCommandLineQuery::handle() {
  // TODO: vector of ints and removing first is not correctly implemented yet. How to remove from a vector?
  periodentafel *periode = World::getInstance().getPeriode();
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    vector<int> AllElements = CommandLineParser::getInstance().vm[getTitle()].as< vector<int> >();
    vector<const element *> temp_elements;
    for (vector<int>::iterator ZRunner = AllElements.begin(); ZRunner != AllElements.end(); ++ZRunner) {
      temp = periode->FindElement(*ZRunner);
      ASSERT(temp != NULL, "Invalid element specified in ElementCommandLineQuery");
      temp_elements.push_back(temp);
    }
    tmp.set(temp_elements);
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing elements for " << getTitle() << ".");
    return false;
  }
}

