/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

CommandLineDialog::ElementCommandLineQuery::ElementCommandLineQuery(Parameter<const element*> &param, std::string title, std::string _description) :
    Dialog::ElementQuery(param, title, _description)
{}

CommandLineDialog::ElementCommandLineQuery::~ElementCommandLineQuery()
{}

bool CommandLineDialog::ElementCommandLineQuery::handle() {
  // TODO: vector of ints and removing first is not correctly implemented yet. How to remove from a vector?
  periodentafel *periode = World::getInstance().getPeriode();
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    int Z = CommandLineParser::getInstance().vm[getTitle()].as< int >();
    tmp.set(periode->FindElement(Z));
    ASSERT(tmp.get() != NULL, "Invalid element specified in ElementCommandLineQuery");
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing element for " << getTitle() << ".");
    return false;
  }
}

