/*
 * CommandLineQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEQUERY_HPP_
#define COMMANDLINEQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CommandLineUI/CommandLineDialog.hpp"

class CommandLineDialog::EmptyCommandLineQuery : public Dialog::EmptyQuery {
public:
  EmptyCommandLineQuery(std::string title, std::string _description = "");
  virtual ~EmptyCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::IntCommandLineQuery : public Dialog::IntQuery {
public:
  IntCommandLineQuery(Parameter<int> &param, std::string title, std::string _description = "");
  virtual ~IntCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::IntsCommandLineQuery : public Dialog::IntsQuery {
public:
  IntsCommandLineQuery(Parameter<std::vector<int> > &param, std::string title, std::string _description = "");
  virtual ~IntsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::UnsignedIntCommandLineQuery : public Dialog::UnsignedIntQuery {
public:
  UnsignedIntCommandLineQuery(Parameter<unsigned int> &param, std::string title, std::string _description = "");
  virtual ~UnsignedIntCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::UnsignedIntsCommandLineQuery : public Dialog::UnsignedIntsQuery {
public:
  UnsignedIntsCommandLineQuery(Parameter<std::vector<unsigned int> > &param, std::string title, std::string _description = "");
  virtual ~UnsignedIntsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::BooleanCommandLineQuery : public Dialog::BooleanQuery {
public:
  BooleanCommandLineQuery(Parameter<bool> &param, std::string title, std::string _description = "");
  virtual ~BooleanCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::DoubleCommandLineQuery : public Dialog::DoubleQuery {
public:
  DoubleCommandLineQuery(Parameter<double> &param, std::string title, std::string _description = "");
  virtual ~DoubleCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::DoublesCommandLineQuery : public Dialog::DoublesQuery {
public:
  DoublesCommandLineQuery(Parameter<std::vector<double> > &param, std::string title, std::string _description = "");
  virtual ~DoublesCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::StringCommandLineQuery : public Dialog::StringQuery {
public:
  StringCommandLineQuery(Parameter<std::string> &param, std::string title, std::string _description = "");
  virtual ~StringCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::StringsCommandLineQuery : public Dialog::StringsQuery {
public:
  StringsCommandLineQuery(Parameter<std::vector<std::string> > &param, std::string title, std::string _description = "");
  virtual ~StringsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::AtomCommandLineQuery : public Dialog::AtomQuery {
public:
  AtomCommandLineQuery(Parameter<const atom *> &param, std::string title, std::string _description = "");
  virtual ~AtomCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::AtomsCommandLineQuery : public Dialog::AtomsQuery {
public:
  AtomsCommandLineQuery(Parameter<std::vector<const atom *> > &param, std::string title, std::string _description = "");
  virtual ~AtomsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::MoleculeCommandLineQuery : public Dialog::MoleculeQuery {
public:
  MoleculeCommandLineQuery(Parameter<const molecule *> &param, std::string title, std::string _description = "");
  virtual ~MoleculeCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::MoleculesCommandLineQuery : public Dialog::MoleculesQuery {
public:
  MoleculesCommandLineQuery(Parameter<std::vector<const molecule *> > &param, std::string title, std::string _description = "");
  virtual ~MoleculesCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::VectorCommandLineQuery : public Dialog::VectorQuery {
public:
  VectorCommandLineQuery(Parameter<Vector> &param, std::string title,bool _check, std::string _description = "");
  virtual ~VectorCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::VectorsCommandLineQuery : public Dialog::VectorsQuery {
public:
  VectorsCommandLineQuery(Parameter<std::vector<Vector> > &param, std::string title,bool _check, std::string _description = "");
  virtual ~VectorsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::RealSpaceMatrixCommandLineQuery : public Dialog::RealSpaceMatrixQuery {
public:
  RealSpaceMatrixCommandLineQuery(Parameter<RealSpaceMatrix> &param, std::string title, std::string _description = "");
  virtual ~RealSpaceMatrixCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::ElementCommandLineQuery : public Dialog::ElementQuery {
public:
  ElementCommandLineQuery(Parameter<const element *> &param, std::string title, std::string _description = "");
  virtual ~ElementCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::ElementsCommandLineQuery : public Dialog::ElementsQuery {
public:
  ElementsCommandLineQuery(Parameter<std::vector<const element *> > &param, std::string title, std::string _description = "");
  virtual ~ElementsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::FileCommandLineQuery : public Dialog::FileQuery {
public:
  FileCommandLineQuery(Parameter<boost::filesystem::path> &param, std::string title, std::string _description = "");
  virtual ~FileCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::FilesCommandLineQuery : public Dialog::FilesQuery {
public:
  FilesCommandLineQuery(Parameter<std::vector< boost::filesystem::path> > &param, std::string title, std::string _description = "");
  virtual ~FilesCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::RandomNumberDistribution_ParametersCommandLineQuery : public Dialog::RandomNumberDistribution_ParametersQuery {
public:
  RandomNumberDistribution_ParametersCommandLineQuery(Parameter<RandomNumberDistribution_Parameters> &param, std::string title, std::string _description = "");
  virtual ~RandomNumberDistribution_ParametersCommandLineQuery();
  virtual bool handle();
};

#endif /* COMMANDLINEQUERY_HPP_ */
