/*
 * NotMoleculeOfAtomAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotMoleculeOfAtomAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotMoleculeOfAtomState : public ActionState {
public:
  SelectionNotMoleculeOfAtomState(std::vector<molecule*> selectedMolecules, atom *_Walker) :
    selectedMolecules(selectedMolecules),
    Walker(_Walker)
  {}
  std::vector<molecule*> selectedMolecules;
  atom *Walker;
};

const char SelectionNotMoleculeOfAtomAction::NAME[] = "unselect-molecule-of-atom";

SelectionNotMoleculeOfAtomAction::SelectionNotMoleculeOfAtomAction() :
  Action(NAME)
{}

SelectionNotMoleculeOfAtomAction::~SelectionNotMoleculeOfAtomAction()
{}

void SelectionNotMoleculeOfAtom() {
  ActionRegistry::getInstance().getActionByName(SelectionNotMoleculeOfAtomAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotMoleculeOfAtomAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryAtom(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotMoleculeOfAtomAction::performCall() {
  atom *Walker = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, Walker);

  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Unselecting molecule to which " << Walker->getName() << " belongs." << endl);
  World::getInstance().unselectMoleculeOfAtom(Walker);
  return Action::state_ptr(new SelectionNotMoleculeOfAtomState(selectedMolecules, Walker));
}

Action::state_ptr SelectionNotMoleculeOfAtomAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeOfAtomState *state = assert_cast<SelectionNotMoleculeOfAtomState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(new SelectionNotMoleculeOfAtomState(state->selectedMolecules, state->Walker));
}

Action::state_ptr SelectionNotMoleculeOfAtomAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeOfAtomState *state = assert_cast<SelectionNotMoleculeOfAtomState*>(_state.get());

  World::getInstance().unselectMoleculeOfAtom(state->Walker);

  return Action::state_ptr(new SelectionNotMoleculeOfAtomState(state->selectedMolecules, state->Walker));
}

bool SelectionNotMoleculeOfAtomAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeOfAtomAction::shouldUndo() {
  return true;
}

const string SelectionNotMoleculeOfAtomAction::getName() {
  return NAME;
}
