/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::AtomsCommandLineQuery::AtomsCommandLineQuery(Parameter<std::vector<const atom *> > &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<std::vector<const atom *> >(_param, _title, _description)
{}

CommandLineDialog::AtomsCommandLineQuery::~AtomsCommandLineQuery() {}

bool CommandLineDialog::AtomsCommandLineQuery::handle() {
  std::vector<int> IdxOfAtom;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    try {
      IdxOfAtom = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    } catch(boost::bad_any_cast &e) {
      IdxOfAtom.clear();
      return false;
    }
    const atom *temp_element;
    for (std::vector<int>::iterator iter = IdxOfAtom.begin(); iter != IdxOfAtom.end(); ++iter) {
      temp_element = const_cast<const World &>(World::getInstance()).getAtom(AtomById(*iter));
      if (temp_element)
        temp.push_back(temp_element);
    }
    return true;
  }
  return false;
}

