/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */
/*
 * CreatorUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */
// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CreatorUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Assert.hpp"

#include "Creator.hpp"
#include "stubs/CreatorStub.hpp"

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/additive_combine.hpp>
#include <boost/random/discard_block.hpp>
#include <boost/random/inversive_congruential.hpp>
#include <boost/random/lagged_fibonacci.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/linear_feedback_shift.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/random_number_generator.hpp>
#include <boost/random/ranlux.hpp>
#include <boost/random/shuffle_output.hpp>
#include <boost/random/subtract_with_carry.hpp>
#include <boost/random/xor_combine.hpp>
#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include <typeinfo>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( CreatorTest );


void CreatorTest::setUp()
{
}

void CreatorTest::tearDown()
{
}

void CreatorTest::CreationTest()
{
  class CreatorStub<teststubs::Aclass> teststubA;
  class CreatorStub<teststubs::Bclass> teststubB;

  ICreatorStub* testingA1 = teststubA.create();
  ICreatorStub* testingA2 = teststubA.create();
  ICreatorStub* testingB = teststubB.create();

  // instance is different
  CPPUNIT_ASSERT( &teststubA != testingA1 );
  CPPUNIT_ASSERT( &teststubA != testingA2 );
  CPPUNIT_ASSERT( testingA1 != testingA2 );
  CPPUNIT_ASSERT( &teststubB != testingB );

  // type is the same ...
  CPPUNIT_ASSERT_EQUAL( typeid(teststubA).name(), typeid(*testingA1).name() );
  CPPUNIT_ASSERT_EQUAL( typeid(*testingA1).name(), typeid(*testingA2).name() );
  CPPUNIT_ASSERT_EQUAL( typeid(teststubB).name(), typeid(*testingB).name() );

  // ... for the same particular type only!
  // (RTTI knows about the true complex type!)
  CPPUNIT_ASSERT( typeid(*testingB).name() != typeid(*testingA1).name() );
  CPPUNIT_ASSERT( typeid(*testingB).name() != typeid(*testingA2).name() );

  // but not for different encapsulated types
  CPPUNIT_ASSERT( typeid(teststubA).name() != typeid(*testingB).name() );
  CPPUNIT_ASSERT( typeid(teststubB).name() != typeid(*testingA1).name() );
  CPPUNIT_ASSERT( typeid(teststubB).name() != typeid(*testingA2).name() );

  delete testingA1;
  delete testingA2;
  delete testingB;
}

void CreatorTest::IndividualityTest()
{
  class CreatorStub<teststubs::Aclass> teststubA;
  class CreatorStub<teststubs::Bclass> teststubB;
  teststubA.count();
  teststubB.count();
  teststubB.count();

  ICreatorStub* testingA1 = teststubA.create();
  ICreatorStub* testingA2 = teststubA.create();
  ICreatorStub* testingB1 = teststubB.create();
  ICreatorStub* testingB2 = teststubB.create();

  // content is the same (prototype has been copied)
  CPPUNIT_ASSERT( teststubA.getcount() != testingA1->getcount());
  CPPUNIT_ASSERT( teststubA.getcount() != testingA2->getcount());
  CPPUNIT_ASSERT( teststubB.getcount() != testingB1->getcount());
  CPPUNIT_ASSERT( teststubB.getcount() != testingB2->getcount());

  // but each copy is independent
  testingA1->count();
  CPPUNIT_ASSERT( testingA1->getcount() != testingA2->getcount());
  testingB1->count();
  testingB2->count();
  testingB2->count();
  CPPUNIT_ASSERT( testingB1->getcount() != testingB2->getcount());

  delete testingA1;
  delete testingA2;
  delete testingB1;
  delete testingB2;
}
