/*
 * QtLogBox.hpp
 *
 *  Created on: Jun 19, 2014
 *      Author: heber
 */

#ifndef QTLOGBOX_HPP_
#define QTLOGBOX_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QPlainTextEdit>

#include <iosfwd>
#include <string>

#include "UIElements/Views/Qt4/QDebugStream.hpp"
#include "types.hpp"



/** This widget displays the log and allows for clicking on the names of atoms
 * which (un)selects them for highlighting.
 *
 */
class QtLogBox : public QPlainTextEdit
{
  Q_OBJECT

public:
  QtLogBox(std::ostream &stream, QWidget * _parent=0);
  virtual ~QtLogBox();

  virtual void mousePressEvent(QMouseEvent *e);

private:
  atomId_t getAtomIdForName(const std::string &_name) const;

private:
  //!> streambuffer to connect ostream and QTextEdit
  QDebugStream logbuf;
};


#endif /* QTLOGBOX_HPP_ */
