/*
 * atom_particleinfo.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_PARTICLEINFO_HPP_
#define ATOM_PARTICLEINFO_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "atom_observable.hpp"

#include <iosfwd>
#include <string>

/****************************************** forward declarations *****************************/


/********************************************** declarations *******************************/

class ParticleInfo : public virtual AtomObservable {
public:
  ParticleInfo();
  ParticleInfo(ParticleInfo*);
  virtual ~ParticleInfo();

  /** Getter for name.
   *
   * @return name of particle
   */
  const std::string& getName() const;
  /** Getter for Nr.
   *
   * @return number of particle
   */
  const int& getNr() const;
  /** Setter for Nr.
   *
   * @param newnr number of particle
   */
  void setNr(const int newnr);
  /** Setter for name.
   *
   * @param newname new name of particle
   */
  void setName(const std::string &newname);

  ostream & operator << (ostream &ost) const;

protected:
  int Nr;       // index to easierly identify, only protected as used in atom::sort

private:
  std::string name;   // some name to reference to on output
};

ostream & operator << (ostream &ost, const ParticleInfo &a);

#endif /* ATOM_PARTICLEINFO_HPP_ */
