/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atom_observable.cpp
 *
 *  Created on: Sep 1, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Assert.hpp"

#include "atom_observable.hpp"

/** Constructor for class AtomObservable.
 *
 */
AtomObservable::AtomObservable() :
  Observable("Atom")
{
  NotificationChannels = new Channels(this);
  // add instance for each notification type
  for (size_t type = 0; type < NotificationType_MAX; ++type)
    NotificationChannels->addChannel(type);
}

AtomObservable::~AtomObservable()
{
  delete NotificationChannels;
}
