/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atom_bondedparticleinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"

#include "WorldTime.hpp"

#include "atom_bondedparticleinfo.hpp"

/** Constructor of class BondedParticleInfo.
 */
BondedParticleInfo::BondedParticleInfo() :
  AdaptiveOrder(0),
  MaxOrder(false)
{}

/** Destructor of class BondedParticleInfo.
 */
BondedParticleInfo::~BondedParticleInfo()
{}

void BondedParticleInfo::AppendTrajectoryStep()
{
  ListOfBonds.push_back(BondList());
  LOG(5,"BondedParticleInfo::AppendTrajectoryStep() called, size is " << ListOfBonds.size());
}

const BondList& BondedParticleInfo::getListOfBonds() const
{
  ASSERT(WorldTime::getTime() < ListOfBonds.size(),
      "BondedParticleInfo::getBondsAtStep() - Access out of range: "
      +toString(WorldTime::getTime())
      +" not in [0,"+toString(ListOfBonds.size())+").");
  return ListOfBonds[WorldTime::getTime()];
}

BondList& BondedParticleInfo::getListOfBonds()
{
  // todo: here we actually need a container on whose destruction notifiy is emitted, i.e.
  // similar or simply an ObservedContainer.
  OBSERVE;
  NOTIFY(AtomObservable::BondsChanged);
  const unsigned int size = ListOfBonds.size();
  ASSERT(WorldTime::getTime() <= size,
      "BondedParticleInfo::getBondsAtStep() - Access out of range: "
      +toString(WorldTime::getTime())
      +" not in [0,"+toString(size)+"].");
  if (WorldTime::getTime() == size) {
    UpdateSteps();
  }
  return ListOfBonds[WorldTime::getTime()];
}

const BondList& BondedParticleInfo::getListOfBondsAtStep(unsigned int _step) const
{
  ASSERT(_step < ListOfBonds.size(),
      "BondedParticleInfo::getBondsAtStep() - Access out of range: "
      +toString(_step)
      +" not in [0,"+toString(ListOfBonds.size())+").");
  return ListOfBonds[_step];
}

BondList& BondedParticleInfo::getListOfBondsAtStep(unsigned int _step)
{
  const unsigned int size = ListOfBonds.size();
  ASSERT(_step <= size,
      "BondedParticleInfo::getBondsAtStep() - Access out of range: "
      +toString(_step)
      +" not in [0,"+toString(size)+"].");
  if (_step == size) {
    UpdateSteps();
  }
  return ListOfBonds[_step];
}
