/*
 * FragmentationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/FragmentationAction/FragmentationAction.hpp"
#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "stackclass.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char FragmentationFragmentationAction::NAME[] = "fragment-mol";

FragmentationFragmentationAction::FragmentationFragmentationAction() :
  Action(NAME)
{}

FragmentationFragmentationAction::~FragmentationFragmentationAction()
{}

Dialog* FragmentationFragmentationAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryDouble("distance", ValueStorage::getInstance().getDescription("distance"));
  dialog->queryInt("order", ValueStorage::getInstance().getDescription("order"));

  return dialog;
}

Action::state_ptr FragmentationFragmentationAction::performCall() {
  clock_t start,end;
  molecule *mol = NULL;
  double distance = -1.;
  int order = 0;
  std::string path;
  config *configuration = World::getInstance().getConfig();
  int ExitFlag = 0;

  ValueStorage::getInstance().queryCurrentValue(NAME, path);
  ValueStorage::getInstance().queryCurrentValue("distance", distance);
  ValueStorage::getInstance().queryCurrentValue("order", order);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    ASSERT(mol != NULL, "No molecule has been picked for fragmentation.");
    DoLog(0) && (Log() << Verbose(0) << "Fragmenting molecule with bond distance " << distance << " angstroem, order of " << order << "." << endl);
    DoLog(0) && (Log() << Verbose(0) << "Creating connection matrix..." << endl);
    start = clock();
    mol->CreateAdjacencyList(distance, configuration->GetIsAngstroem(), &BondGraph::CovalentMinMaxDistance, NULL);
    DoLog(0) && (Log() << Verbose(0) << "Fragmenting molecule with current connection matrix ..." << endl);
    if (mol->hasBondStructure()) {
      ExitFlag = mol->FragmentMolecule(order, path);
    }
    World::getInstance().setExitFlag(ExitFlag);
    end = clock();
    DoLog(0) && (Log() << Verbose(0) << "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s." << endl);
  }
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationFragmentationAction::canUndo() {
  return true;
}

bool FragmentationFragmentationAction::shouldUndo() {
  return true;
}

const string FragmentationFragmentationAction::getName() {
  return NAME;
}
