/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Graph6ReaderUnitTest.cpp
 *
 *  Created on: Oct 17, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Graph6ReaderUnitTest.hpp"

#include <iterator>
#include <sstream>

#include "CodePatterns/Assert.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/
// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( Graph6ReaderTest );

const std::string graph6file ="A_";


// set up and tear down
void Graph6ReaderTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

}

void Graph6ReaderTest::tearDown()
{
}

/** Unit tests for Graph6Reader::operator().
 *
 */
void Graph6ReaderTest::operatorTest()
{
  // parse in graph6 string
  std::stringstream input(graph6file);
  reader(input);

  // compare nodes
  CPPUNIT_ASSERT_EQUAL( (int)2, reader.get_num_nodes());

  // compare edges
  CPPUNIT_ASSERT_EQUAL( (size_t)1, reader.get_edges().size());
}
