/*
 * Range.hpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

#ifndef RANGE_HPP_
#define RANGE_HPP_
template <class T>
struct range {
  range(const T&,const T&);
  bool isInRange(const T&) const;
  bool isBefore(const T&) const;
  bool isBeyond(const T&) const;

  T first;
  T last;
};

template <class T>
inline range<T>::range(const T &_first,const T &_last) :
first(_first),last(_last)
{}

template <class T>
inline bool range<T>::isInRange(const T &value) const{
  return first <= value && value < last;
}

template <class T>
inline bool range<T>::isBefore(const T &value) const{
  return value < first;
}

template <class T>
inline bool range<T>::isBeyond(const T &value) const{
 return last <= value;
}

template <class T>
inline range<T> makeRange(const T&first, const T&last){
  return range<T>(first,last);
}

template <class T>
inline bool operator<(const range <T> &x, const range<T> &y){
  return (x.first!=y.first)?x.first<y.first:x.last<y.last;
}

template <class T>
inline bool operator==(const range<T> &x,const range<T> &y){
  return x.first==y.first && x.last==y.last;
}

template <class T>
inline bool operator!= (const range<T>& x, const range<T>& y) { return !(x==y); }
template <class T>
inline bool operator>  (const range<T>& x, const range<T>& y) { return y<x; }
template <class T>
inline bool operator<=(const range<T>& x, const range<T>& y) { return !(y<x); }
template <class T>
inline bool operator>= (const range<T>& x, const range<T>& y) { return !(x<y); }

#endif /* RANGE_HPP_ */
