/*
 * world.cpp
 *
 *  Created on: Mar 3, 2010
 *      Author: crueger
 */

#include "World.hpp"

double *World::cell_size = 0;

/** Constructor of World.
 *
 */
World::World()
{
  cell_size = new double[6];
};

/** Destructor of World.
 *
 */
World::~World()
{
  delete[](cell_size);
};


// TODO: Hide boost-thread using Autotools stuff when no threads are used
World* World::theWorld = 0;


World* World::get(){
  // boost supports RAII-Style locking, so we don't need to unlock
  if(!theWorld) {
    theWorld = new World();
  }
  return theWorld;
}

void World::destroy(){
  delete theWorld;
  theWorld = 0;
}

World* World::reset(){
  World* oldWorld = 0;
  {
    oldWorld = theWorld;
    theWorld = new World();
    // oldworld does not need protection any more,
    // since we should have the only reference

    // worldLock handles access to the pointer,
    // not to the object
  } // scope-end releases the lock

  // we have to let all the observers know that the
  // oldWorld was destroyed. oldWorld calls subjectKilled
  // upon destruction. Every Observer getting that signal
  // should see that it gets the updated new world
  delete oldWorld;
}
