/*
 * Line.hpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

#ifndef LINE_HPP_
#define LINE_HPP_

#include "Space.hpp"

#include <memory>

class Vector;

class Line : public Space
{
public:
  Line(Vector &_origin, Vector &_direction);
  virtual ~Line();

  virtual double distance(const Vector &point) const=0;
  virtual Vector getClosestPoint(const Vector &point) const=0;

private:
  std::auto_ptr<Vector> origin;
  std::auto_ptr<Vector> direction;
};

#endif /* LINE_HPP_ */
