/*
 * Line.cpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

#include "Line.hpp"

#include <cmath>

#include "vector.hpp"

Line::Line(Vector &_origin, Vector &_direction) :
  origin(new Vector(_origin)),
  direction(new Vector(_direction))
{
  direction->Normalize();
}

Line::~Line()
{}


double Line::distance(const Vector &point) const{
  return fabs(point.ScalarProduct(*direction) - origin->ScalarProduct(*direction));
}

Vector Line::getClosestPoint(const Vector &point) const{
  double factor = point.ScalarProduct(*direction) - origin->ScalarProduct(*direction);
  return (point - (factor * (*direction)));
}
