/*
 * GLMoleculeObject_atom.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_ATOM_HPP_
#define GLMOLECULEOBJECT_ATOM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer.hpp"

#include "Atom/atom.hpp"

class GLMoleculeObject_atom : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  GLMoleculeObject_atom(QObject *parent, const atom *atomref);
  virtual ~GLMoleculeObject_atom();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

private slots:
  void wasClicked();

signals:
  void clicked(atomId_t);
  void BondsChanged(const atom *_atom);

private:
  void resetPosition();
  void resetElement();
  void resetIndex();
  void resetProperties();

  const atom *_atom;
};



#endif /* GLMOLECULEOBJECT_ATOM_HPP_ */
